/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.status;

import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.ui.UIObjectProperties;
import com.ibm.hwmca.fw.ui.UIObjectsReader;
import com.ibm.hwmca.fw.ui.UIObjectsWriter;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.ui.bonsai.servlet.util.TaskUrl;
import com.ibm.hwmca.ui.bonsai.servlet.util.UISession;
import com.ibm.hwmca.ui.bonsai.status.AbstractStatusMonitor;
import com.ibm.hwmca.ui.bonsai.status.StatusMonitorBean;
import java.util.Set;

public class HMCStatusMonitor
extends AbstractStatusMonitor {
    private static final String HWMSGS_TEXT_KEY = "status.hmc.hwmsgs";
    private static final String NO_HWMSGS_TEXT_KEY = "status.hmc.nohwmsgs";
    private static String taskUrl;

    public StatusMonitorBean getStatusMonitorBean(UISession session) {
        UIObjectsReader reader = session.getUIObjectsReader();
        Set ids = reader.getShortIdsByType((byte)55);
        if (ids.isEmpty()) {
            return null;
        }
        String id = (String)ids.iterator().next();
        LocalizableText[] details = null;
        String url = null;
        boolean acceptable = !UIObjectProperties.attentionsExist(reader.getBuffer(id));
        if (acceptable) {
            details = new LocalizableText[]{new LocalizableText("com/ibm/hwmca/ui/bonsai/res/text", NO_HWMSGS_TEXT_KEY)};
        } else {
            details = new LocalizableText[]{new LocalizableText("com/ibm/hwmca/ui/bonsai/res/text", HWMSGS_TEXT_KEY)};
            url = HMCStatusMonitor.getHWMessagesTaskUrl(id);
        }
        return new StatusMonitorBean(this.getKey(), this.getUIInfo(), acceptable, details, url);
    }

    private static synchronized String getHWMessagesTaskUrl(String consoleShortId) {
        if (taskUrl != null) {
            return taskUrl;
        }
        ObjectId objId = new ObjectId("com.ibm.hwmca.fw.managed.Task");
        objId.setKeyProperty("Name", "base.task.hwmsg");
        String taskId = UIObjectsWriter.getUIObjectsWriter().getShortObjectIdManager().getShortId(objId);
        taskUrl = new TaskUrl(taskId, 2, consoleShortId).toString();
        return taskUrl;
    }
}

